package org.msh.tb.bd.tbforms.dhis2.tb11.blockbuilders;

import org.msh.tb.bd.tbforms.dhis2.TBFormBlockBuilder;
import org.msh.tb.bd.tbforms.dhis2.data.DataValuePayload;
import org.msh.tb.bd.tbforms.query.tb11.TBForm11Block2Query;
import org.msh.tb.entities.enums.TbFormField;

/**
 * Created by Mauricio on 20/03/2017.
 * Query database and mount TB Form 11 Block 2 Payload to be sent to DHIS2 APIs
 */
public class TBForm11Block2Builder extends TBFormBlockBuilder {

    private TBForm11Block2Query formQuery;

    @Override
    protected void loadAllFieldsAsZero(DataValuePayload payload) {
        for (TbFormField field : getBlockQuery().fields) {
            payload.mergeDataValue(field.getDhis2DataElementId(), field.getDhis2CategoryOptionComboId(), new Long(0));
        }
    }

    @Override
    protected TBForm11Block2Query getBlockQuery() {
        if (formQuery == null) {
            formQuery = new TBForm11Block2Query();
        }

        return formQuery;
    }

    @Override
    protected void mountResultPayload(Object[] result, DataValuePayload payload) {
        TbFormField field = (TbFormField) result[0];
        Integer count = (Integer) result[1];

        // merge payload result
        payload.mergeDataValue(field.getDhis2DataElementId(), field.getDhis2CategoryOptionComboId(), new Long(count));
    }
}
